/*@ requires
  @   \valid(t+(0..n-1)) &&
  @   \forall unsigned int k1, k2; k1 <= k2 < n ==> t[k1] <= t[k2];
  @ assigns \nothing;
  @ ensures
  @   (\result < n && t[\result] == v) ||
  @   (\result == n && \forall unsigned int k; k < n ==> t[k] != v);
  @*/
unsigned int binary_search(long long* t, unsigned int n, long long v) {
  // TODO: fix the implementation and prove it !
  unsigned int l=0, u=n-1;
  while (l <= u ) {
    unsigned int m = (l+u) / 2;
    if (t[m] < v) l = m + 1;
    else if (t[m] > v) u = m - 1;
    else return m;
  }
  return n;
}

////////////////////////
// test driver for binary_search (on a large array)
#include <stdlib.h>
#include "any.h"
#define N 2147484646

int main() {
  unsigned int i;
  int n, k, v;
  long long *t = calloc(N,sizeof(long long));
  if (t==NULL) {
    // no enough memory
    return -1;
  }
  //@ assert (\valid(t+(0..2147484646-1)));  // We admit this property that frama-C does not prove yet !
  n = any(); // 1st integer = num of iterations.
  if (n <= 0) return -1;
  /*@ loop invariant i <= N; 
    @ loop invariant \forall unsigned int k; k < i ==> t[k] == ((long long)k)-1000;
    @ loop assigns i, t[0..i-1];
    @*/
  for (i=0; i<N; i++) {
    t[i]=((long long)i)-1000;
  }
  k = 0;
  /*@ loop invariant k <= n; 
    @ loop assigns k, v, i; */
  while (k < n) {
    k++;
    v = any(); // next integers = value to search
    i = binary_search(t, N, v);
    if (i < N){
      /*@ assert v==i-1000; */
      if (v!=i-1000) return k; // KO!
    } else {
      /*@ assert i==N; */
      if (i!=N) return k; // KO!
    }
  }
  return 0; // OK !
}
